(async function () {
    //  console.debug("inline-get.js");

    const getUrlVideoId = () => {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get('v');
    };

    const targetVideoId = getUrlVideoId();
    // console.debug("[LingoPause] Target Video ID:", targetVideoId);

    let ytdApp;
    let plyRes;
    for (let i = 0; i < 30; i++) {
        ytdApp = document.getElementsByTagName("ytd-app")[0];
        plyRes = ytdApp ? (ytdApp.data ? ytdApp.data.playerResponse : (ytdApp.playerResponse || null)) : null;

        const currentVideoId = plyRes && plyRes.videoDetails ? plyRes.videoDetails.videoId : null;

        if (targetVideoId && currentVideoId === targetVideoId) {
            // console.debug("Found matching playerResponse for", targetVideoId);
            break;
        }

        await new Promise(r => setTimeout(r, 200));
        // console.debug(`retry finding matching playerResponse (${i + 1}) - current: ${currentVideoId}, target: ${targetVideoId}`);
    }

    if (!plyRes) {
        console.warn("playerResponse not ready or video ID mismatch");
        return;
    }

    // console.debug("got ytd-app[0] playerResponse");

    // console.debug("plyRes 's type is", typeof (plyRes));
    // console.debug("plyRes 's keys length is", Object.keys(plyRes).length);

    document.body.setAttribute("data-playerResponse", JSON.stringify(
        plyRes
    ));

    // console.debug("typeof body's attr is",
    //     typeof (document.body.getAttribute('data-playerResponse'))
    // );
    // console.debug("length of body's attr is", document.body.getAttribute('data-playerResponse').length);
})();
