// Load Kuroshiro from local files by requesting background script to inject
// Content scripts can't use chrome.tabs, so we use chrome.runtime.sendMessage
(function () {
    // console.debug("[LingoPause] ssLoading Kuroshiro from local files...");

    async function loadKuroshiroScripts() {
        try {
            // Request background script to load and inject the scripts
            const response = await new Promise((resolve) => {
                chrome.runtime.sendMessage(
                    { action: "load-kuroshiro" },
                    (response) => {
                        if (chrome.runtime.lastError) {
                            resolve({ success: false, error: chrome.runtime.lastError.message });
                        } else {
                            resolve(response || { success: false, error: "No response" });
                        }
                    }
                );
            });

            if (response.success) {
                // console.debug("Kuroshiro loaded successfully in page context");
            } else {
                throw new Error(response.error || "Unknown error");
            }
        } catch (error) {
            console.error("Failed to load Kuroshiro:", error);
            // Set flag anyway to prevent infinite retries
            try {
                document.documentElement.setAttribute('data-kuroshiro-loaded', 'error');
            } catch (e) {
                // Ignore if we can't set attribute
            }
        }
    }

    // Start loading
    loadKuroshiroScripts();
})();

